#ifndef _SSDT_FUNCTION_H_
#define _SSDT_FUNCTION_H_


#include <ntddk.h>
#include <ntimage.h>
#include <intrin.h>


#ifndef _WIN64
    // 32 Bits
    #pragma pack(1)
    typedef struct _SERVICE_DESCIPTOR_TABLE 
    {
	    PULONG ServiceTableBase;		  // SSDTַ
	    PULONG ServiceCounterTableBase;   // SSDTз񱻵ô
	    ULONG NumberOfService;            // SSDT
	    PUCHAR ParamTableBase;		      // ϵͳַ
    }SSDTEntry, *PSSDTEntry;
#pragma pack()
    // ֱӻȡ SSDT 
   extern SSDTEntry __declspec(dllimport) KeServiceDescriptorTable;

#else
    // 64 Bits
    #pragma pack(1)
    typedef struct _SERVICE_DESCIPTOR_TABLE
    {
	    PULONG ServiceTableBase;		  // SSDTַ
	    PVOID ServiceCounterTableBase; // SSDTз񱻵ô
	    ULONGLONG NumberOfService;     // SSDT
	    PVOID ParamTableBase;		  // ϵͳַ
    }SSDTEntry, *PSSDTEntry;
    #pragma pack()

#endif


// ȡ SSDT ַ
PVOID GetSSDTFunction(PCHAR pszFunctionName);

// 32λ, ֱӻȡַ; 64λ, ,  KiSystemCall64 лȡ SSDT ַ
PVOID GetSSDTAddress();

//  ntdll.dll лȡ SSDT 
ULONG GetSSDTFunctionIndex(UNICODE_STRING ustrDllFileName, PCHAR pszFunctionName);
// ڴӳļ
NTSTATUS DllFileMap(UNICODE_STRING ustrDllFileName, HANDLE *phFile, HANDLE *phSection, PVOID *ppBaseAddress);
// ݵȡַ, Ӷȡ SSDT 
ULONG GetIndexFromExportTable(PVOID pBaseAddress, PCHAR pszFunctionName);


#endif