#include "base.h"
#include "biosSnSearch.h"

char smbios_version_string[32]; /* e.g. V2.31 */



void RandomizeSerialNumber(char* str, int length)
{
#define CHARSET "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789"
#define CHARSET_SIZE (sizeof(CHARSET) - 1)

	LARGE_INTEGER seed;
	KeQuerySystemTime(&seed);
	ULONG randSeed = (ULONG)(seed.QuadPart & 0xFFFFFFFF);

	for (int i = 0; i < length; i++) {
		randSeed = RtlRandomEx(&randSeed);
		str[i] = CHARSET[randSeed % CHARSET_SIZE];
	}
	str[length] = '\0'; // ַ
}

unsigned char smbios_check_entry_point(void* addr)
{
	unsigned char* i;
	unsigned char checksum = 0;
	unsigned char length = ((struct smbios_entry_point_struct*)addr)->entry_point_length;
	/* calculate checksum for entry point structure (should be 0) */
	for (i = (unsigned char*)addr; i < (unsigned char*)addr + length; i++)
		checksum += *i;
	return checksum;
}

struct smbios_entry_point_struct* smbios_find_entry_point(void* base, unsigned long nLen)
{
	struct smbios_entry_point_struct* entry_point = 0;	/** SM-BIOS entry point */
	unsigned int* temp;				        /** temp. pointer       */


	/* search for the magic dword - '_SM_? as DWORD formatted -  on paragraph boundaries */
	for (temp = (unsigned int*)base;
		!entry_point 
		&& (temp < (unsigned int*)base + BIOS_MAP_LENGTH) 
		&& ((unsigned char*)temp < (unsigned char*)base+ nLen);
		temp += 4)
	{
		/* found the identifier ? */
		if (*temp == SMBIOS_MAGIC_DWORD)
		{
			/* check if entry point valid (build checksum) */
			if (!(smbios_check_entry_point(temp)))
			{
				entry_point = (struct smbios_entry_point_struct*)temp;

				/* fix display of Bios version string */
				/* SMBios version is known as 2.1, 2.2, 2.3 and 2.3.1, never as 2.01 (JB) */
				DbgPrint("SM-BIOS V%d.%d entry point found at 0x%p\n",
					entry_point->major_version, entry_point->minor_version, (unsigned int*)temp);

				DbgPrint("V%d.%d\n", entry_point->major_version, entry_point->minor_version);
			}
		}
	}
	return entry_point;
}

struct dmibios_entry_point_struct* dmibios_find_entry_point(void* base, unsigned long nLen)
{
	struct dmibios_entry_point_struct* entry_point = 0;	    /** DMI-BIOS entry point */
	unsigned char* temp = 0;			                /** temp. pointer        */
	unsigned char biossignature[] =		                /** '_DMI20_NT_'         */
	{ 0x5f, 0x44, 0x4d, 0x49, 0x32, 0x30, 0x5f, 0x4e, 0x54, 0x5f };

	/* search for the DMI-BIOS signature on character boundary (hm?) */
	for (temp = (unsigned char*)base;
		!entry_point 
		&& (temp < (__u8*)base + BIOS_MAP_LENGTH - sizeof(biossignature) - 32)
		&& ((unsigned char*)temp < (unsigned char*)base + nLen);
		temp++)
	{
		unsigned long* tempdword = (unsigned long*)temp;

		/* found the identifier '_DMI' ?     (beginning of signature) */
		if (*tempdword == DMIBIOS_MAGIC_DWORD)
		{
			entry_point = (struct dmibios_entry_point_struct*)temp;

			DbgPrint("DMI-BIOS revision %d entry point at 0x%p\n",
				entry_point->revision, (unsigned int*)temp);

			sprintf(smbios_version_string, "V%d\n", entry_point->revision);

			if (memcmp(temp, biossignature, sizeof(biossignature)) == 0)
				DbgPrint("DMI BIOS successfully identified\n");
		}
	}
	return entry_point;
}

//--------------
void process_smbios_table(SMBIOS_HEADER* header)
{
	auto TableLength = [](PSMBIOS_HEADER pHeader) -> size_t
	{
		char* current = reinterpret_cast<char*>(pHeader) + pHeader->Length;
		size_t i = 1;

		for (i; current[i - 1] != '\0' || current[i] != '\0'; i++)
		{
			// Scan until we find a double zero byte
		}

		return pHeader->Length + i + 1;
	};

	auto GetString = [](PSMBIOS_HEADER pHeader, unsigned char id, int nLen) -> char*
	{
		UNREFERENCED_PARAMETER(id);
		UNREFERENCED_PARAMETER(nLen);

		char* string = reinterpret_cast<char*>(pHeader) + pHeader->Length;

		char hexOutput[256] = { 0 };
		//stringToHex(string, hexOutput, nLen);
		DbgPrint("%s\r\n", hexOutput);

		for (DWORD i = 1; i < id; i++)
		{
			string += strlen(string) + 1;
		}

		return string;
	};

	{
		char* serialNumber = NULL, * Uuid = NULL, * ProcessorManufacturer = NULL;

		if (header->Type == 1) //bios
		{
			SMBIOS_TYPE1* pSystemInfoHeader = reinterpret_cast<SMBIOS_TYPE1*>(header);

			serialNumber = GetString((SMBIOS_HEADER*)pSystemInfoHeader, pSystemInfoHeader->SerialNumber,
				header->Length);

			DbgPrint("read SystemInfo: serialNumber:%s\r\n", serialNumber);
		}
		else if (header->Type == 2) //к
		{
			SMBIOS_TYPE3* pBaseBoardHeader = reinterpret_cast<SMBIOS_TYPE3*>(header);

			serialNumber = GetString((SMBIOS_HEADER*)pBaseBoardHeader, pBaseBoardHeader->SerialNumber,
				header->Length);
			DbgPrint("read BaseBoard: %s\r\n", serialNumber);
		}
		else if (header->Type == 4) // CPU
		{
			SMBIOS_TYPE4* pCpuHeader = reinterpret_cast<SMBIOS_TYPE4*>(header);

			serialNumber = GetString((SMBIOS_HEADER*)pCpuHeader, pCpuHeader->SerialNumber,
				header->Length);

			if (pCpuHeader->ProcessorType & 3) //CPU
			{
				DbgPrint("read CPU: serialNumber:%s.ProcessorManufacturer:%s.Len:%d\r\n", serialNumber,
					ProcessorManufacturer, header->Length);
			}
			else if (pCpuHeader->ProcessorType & 6) //Video
			{
				DbgPrint("read Video: serialNumber:%s.ProcessorManufacturer:%s.Len:%d\r\n", serialNumber,
					ProcessorManufacturer, header->Length);
			}
		}
		else if (header->Type == 17) // MemoryDevice
		{
			PMEMORY_DEVICE_HEADER pMemoryDeviceHeader = reinterpret_cast<PMEMORY_DEVICE_HEADER>(header);

			serialNumber = GetString((SMBIOS_HEADER*)pMemoryDeviceHeader, pMemoryDeviceHeader->serialNumber,
				header->Length);
			DbgPrint("read MemoryDevice: %s\r\n", serialNumber);
		}

		if (serialNumber)
		{
			if (header->Type == 1) // SystemInfo bios
			{
				SMBIOS_TYPE1* pSystemInfoHeader = reinterpret_cast<SMBIOS_TYPE1*>(header);

				RandomizeSerialNumber(serialNumber, 12);
				DbgPrint("write: %s\r\n", serialNumber);

				serialNumber = GetString((SMBIOS_HEADER*)pSystemInfoHeader, pSystemInfoHeader->SerialNumber,
					header->Length);
				DbgPrint("re-read BaseBoard bios: %s.Len:%d\r\n", serialNumber, header->Length);

				memset(&pSystemInfoHeader->Uuid, 0, sizeof(pSystemInfoHeader->Uuid));
			}
			else if (header->Type == 2) // BaseBoard Physical SN
			{
				SMBIOS_TYPE3* pBaseBoardHeader = reinterpret_cast<SMBIOS_TYPE3*>(header);

				RandomizeSerialNumber(serialNumber, 12);
				DbgPrint("write: %s\r\n", serialNumber);

				serialNumber = GetString((SMBIOS_HEADER*)pBaseBoardHeader, pBaseBoardHeader->SerialNumber,
					header->Length);
				DbgPrint("re-read BaseBoard: %s.Len:%d\r\n", serialNumber, header->Length);
			}
			else if (header->Type == 4) // CPU
			{
				SMBIOS_TYPE4* pCpuHeader = reinterpret_cast<SMBIOS_TYPE4*>(header);

				RandomizeSerialNumber(serialNumber, 12);
				DbgPrint("write: %s\r\n", serialNumber);

				serialNumber = GetString((SMBIOS_HEADER*)pCpuHeader, pCpuHeader->SerialNumber/*ProcessorId*/,
					header->Length);
				ProcessorManufacturer = GetString((SMBIOS_HEADER*)pCpuHeader,
					pCpuHeader->ProcessorManufacturer,
					header->Length);
				if (pCpuHeader->ProcessorType & 3) //CPU
				{
					DbgPrint("re-read CPU: serialNumber:%s.ProcessorManufacturer:%s.Len:%d\r\n", serialNumber,
						ProcessorManufacturer, header->Length);
				}
				else if (pCpuHeader->ProcessorType & 6) //Video
				{
					DbgPrint("re-read Video: serialNumber:%s.ProcessorManufacturer:%s.Len:%d\r\n", serialNumber,
						ProcessorManufacturer, header->Length);
				}
			}
			else if (header->Type == 17) // MemoryDevice
			{
				RandomizeSerialNumber(serialNumber, 12);
				DbgPrint("write: %s\r\n", serialNumber);

				PMEMORY_DEVICE_HEADER pMemoryDeviceHeader = reinterpret_cast<PMEMORY_DEVICE_HEADER>(header);

				serialNumber = GetString((SMBIOS_HEADER*)pMemoryDeviceHeader, pMemoryDeviceHeader->serialNumber,
					header->Length);
				DbgPrint("re-read MemoryDevice: %s\r\n", serialNumber);
			}
		}

		header = (PSMBIOS_HEADER)((char*)header + TableLength(header));
	}

	DbgPrint("[WmipRawSMBiosTableHandlerHook] Serial numbers spoofed.");
}

void handle_smbios_table(void* mapped, unsigned long length)
{
	char* end_address = static_cast<char*>(mapped) + length;

	while (true)
	{
		SMBIOS_HEADER* header = static_cast<SMBIOS_HEADER*>(mapped);
		if (header->Type == 127 && header->Length == 4)
			break;

		process_smbios_table(header);

		char* ptr = static_cast<char*>(mapped) + header->Length;
		while (0 != (*ptr | *(ptr + 1))) ptr++;
		ptr += 2;
		if (ptr >= end_address)
			break;

		mapped = ptr;
	}
}
