#include "base.h"
#include "biosSnSearch.h"

BYTE szSystemInfo[4096]; //ڳִϺ󣬴˴洢ȡõϵͳ
UINT uSystemInfoLen = 0; //ڳִϺ󣬴˴洢ȡõϵͳĳ

//ָ
typedef DWORD(__stdcall* ZWOS)(PHANDLE, ACCESS_MASK, POBJECT_ATTRIBUTES);
typedef DWORD(__stdcall* ZWMV)(HANDLE, HANDLE, PVOID, ULONG, ULONG, PLARGE_INTEGER, PSIZE_T, DWORD, ULONG, ULONG);
typedef DWORD(__stdcall* ZWUMV)(HANDLE, PVOID);

#define InitializeObjectAttributes( p, n, a, r, s ) { \
    (p)->Length = sizeof( OBJECT_ATTRIBUTES );          \
    (p)->RootDirectory = r;                             \
    (p)->Attributes = a;                                \
    (p)->ObjectName = n;                                \
    (p)->SecurityDescriptor = s;                        \
    (p)->SecurityQualityOfService = NULL;               \
    }
#define OBJ_CASE_INSENSITIVE                0x00000040L

void PrintfHexString(BYTE* pbData,int nLen)
{
	int nLine = nLen / 16;
	int nRemainder= nLen % 16;

	for (int j=0;j< nLine;j++)
	{
		//ʾ16
		for (int i = j*16; i < 16+ j * 16; i++)
		{
			DbgPrint("%02x ", pbData[i]);
		}
		DbgPrint("| ");

		//ʾݵ
		for (int i = j * 16; i < 16 + j * 16; i++)
		{
			DbgPrint("%c", isprint(pbData[i]) ? pbData[i] : '.');
		}
		DbgPrint("\r\n");
	}

	//ӡʣ
	for (int i = 0; i < nRemainder; i++)
	{
		DbgPrint("%02x ", pbData[i]);
	}
	DbgPrint("| ");

	for (int i = 0; i < nRemainder; i++)
	{
		DbgPrint("%c", isprint(pbData[i]) ? pbData[i] : '.');
	}
	
	DbgPrint(" |");
	DbgPrint("\n");
}

UINT FindAwardBios(BYTE** ppBiosAddr)
{
	BYTE* pBiosAddr = *ppBiosAddr + 0xEC71;

	BYTE szBiosData[128];
	RtlCopyMemory(szBiosData, pBiosAddr, 127);
	szBiosData[127] = 0;

	int iLen = strlen((char*)szBiosData);
	if (iLen > 0 && iLen < 128)
	{
		//AWard:         07/08/2002-i845G-ITE8712-JF69VD0CC-00 
		//Phoenix-Award: 03/12/2002-sis645-p4s333
		if (szBiosData[2] == '/' && szBiosData[5] == '/')
		{
			BYTE* p = szBiosData;
			while (*p)
			{
				if (*p < ' ' || *p >= 127)
				{
					break;
				}
				++p;
			}
			if (*p == 0)
			{
				*ppBiosAddr = pBiosAddr;
				return (UINT)iLen;
			}
		}
	}
	return 0;
}

UINT FindAmiBios(BYTE** ppBiosAddr) //American Megatrends Inc
{
	BYTE* pBiosAddr = *ppBiosAddr + 0xF478;

	BYTE szBiosData[128];
	RtlCopyMemory(szBiosData, pBiosAddr, 127);
	szBiosData[127] = 0;

	int iLen = strlen((char*)szBiosData);
	if (iLen > 0 && iLen < 128)
	{
		// Example: "AMI: 51-2300-000000-00101111-030199-"
		if (szBiosData[2] == '-' && szBiosData[7] == '-')
		{
			BYTE* p = szBiosData;
			while (*p)
			{
				if (*p < ' ' || *p >= 127)
				{
					break;
				}
				++p;
			}
			if (*p == 0)
			{
				*ppBiosAddr = pBiosAddr;
				return (UINT)iLen;
			}
		}
	}
	return 0;
}

UINT FindPhoenixBios(BYTE** ppBiosAddr)
{
	UINT uOffset[3] = { 0x6577, 0x7196, 0x7550 }; //AC q UP
	for (UINT i = 0; i < 3; ++i)
	{
		BYTE* pBiosAddr = *ppBiosAddr + uOffset[i];

		BYTE szBiosData[128];
		RtlCopyMemory(szBiosData, pBiosAddr, 127);
		szBiosData[127] = 0;

		int iLen = strlen((char*)szBiosData);
		if (iLen > 0 && iLen < 128)
		{
			// Example: Phoenix "NITELT0.86B.0044.P11.9910111055"
			if (szBiosData[7] == '.' && szBiosData[11] == '.')
			{
				BYTE* p = szBiosData;
				while (*p)
				{
					if (*p < ' ' || *p >= 127)
					{
						break;
					}
					++p;
				}
				if (*p == 0)
				{
					*ppBiosAddr = pBiosAddr;
					return (UINT)iLen;
				}
			}
		}
	}
	return 0;
}

BOOL ParseSMBios(PVOID smbios_base,unsigned long nLen)
{
	/*
	 *   SMBIOSDMIBIOSڵ㣨EPSʼַ
	 */
	struct smbios_entry_point_struct* smbios_entry_point1 = NULL;
	struct dmibios_entry_point_struct* dmibios_entry_point1=NULL;
	void* smbios_structures_base = NULL;

	if (!(smbios_entry_point1 = smbios_find_entry_point(smbios_base,nLen)))
	{
		DbgPrint("SM-BIOS entry point not found\r\n");
		if (!(dmibios_entry_point1 = dmibios_find_entry_point(smbios_base, nLen)))
		{
			DbgPrint("DMI-BIOS entry point not found. Aborting...\r\n");
			return FALSE;
		}
		DbgPrint("DMI-BIOS entry point found\r\n");
	}

	if (smbios_entry_point1)
	{
		if (strncmp((char*)&(smbios_entry_point1->intermediate_string),
			DMI_STRING, sizeof(DMI_STRING) - 1))
		{
			DbgPrint("Pointer to DMI structures not found!\r\n");
			return FALSE;
		}
	}

	if (smbios_entry_point1)
	{
		PHYSICAL_ADDRESS pa = { 0 };
		pa.QuadPart = smbios_entry_point1->struct_table_address;
		if (!(smbios_structures_base =
			MmMapIoSpace(pa,
				(unsigned long)smbios_entry_point1->struct_table_length, MmNonCached)))
		{
			DbgPrint("MmMapIoSpace() for structures table failed\r\n");
			return FALSE;
		}
	}
	DbgPrint("MmMapIoSpace() success,0x%p\r\n", smbios_structures_base);

	if (dmibios_entry_point1)
	{
		if (!(smbios_structures_base = dmibios_entry_point1->entry))
		{
			DbgPrint("invalid structure table entry%p,%p\r\n", smbios_structures_base,
				dmibios_entry_point1->entry);
			MmUnmapIoSpace(smbios_structures_base,
				smbios_entry_point1->struct_table_length);
			return FALSE;
		}
	}
	DbgPrint("DMI structures base set to 0x%p\r\n", smbios_structures_base);

	PrintfHexString((BYTE*)smbios_structures_base, 
		smbios_entry_point1->struct_table_length);

	handle_smbios_table(smbios_structures_base, 
		smbios_entry_point1->struct_table_length);

	MmUnmapIoSpace(smbios_structures_base, 
		smbios_entry_point1->struct_table_length);
	return TRUE;
}

// BIOS ţ֧ AMI, AWARD, PHOENIX
BOOL GetBiosSn()
{
	DbgPrint("enter GetBiosSn!\r\n");

	BOOL ret = FALSE;

	SIZE_T ssize;

	LARGE_INTEGER so;
	so.LowPart = 0x000f0000;
	so.HighPart = 0x00000000;
	ssize = 0xffff;
	wchar_t strPH[30] = L"\\device\\physicalmemory";

	PVOID ba = 0;

	UNICODE_STRING struniph;
	struniph.Buffer = strPH;
	struniph.Length = wcslen(strPH) * 2;
	struniph.MaximumLength = wcslen(strPH) * 2 + 2;

	OBJECT_ATTRIBUTES obj_ar = {0};
	InitializeObjectAttributes(
		&obj_ar,
		&struniph,
		OBJ_CASE_INSENSITIVE,
		NULL,
		NULL);

	//úڴӳ 
	HANDLE hSection;

	//ִкڵǰ̵Ŀռ俪һ64kĿռ䣬f000:0000f000:ffffӳ䵽 
	//ӳĻַba,ӳ䲻,ӦZwUnmapViewOfSectionϿӳ 

	DbgPrint("0x%p", NtCurrentProcess());

	NTSTATUS status;
	status = ZwOpenSection(&hSection, SECTION_MAP_READ, &obj_ar);
	if (NT_SUCCESS(status))
	{
		status = ZwMapViewOfSection(
			(HANDLE)hSection,   //Sectionʱõľ 
			(HANDLE)/*0xFFFFFFFF*/NtCurrentProcess(), //Ҫӳ̵ľ 
			&ba,                  //ӳĻַ 
			0,
			0xFFFF,               //ĴС 
			&so,                  //ڴĵַ 
			&ssize,               //ָȡڴСָ 
			/*1*/ViewShare,                    //ӽ̵Ŀɼ̳趨 
			0,                // 
			PAGE_READWRITE | PAGE_NOCACHE                     // 
		);
		if (NT_SUCCESS(status))
		{
			BYTE* pBiosSerial = (BYTE*)ba;
			int nMapSize = 0xFFFF;
			//PrintfHexString(pBiosSerial, nMapSize);

			ParseSMBios(ba, nMapSize);

			UINT uBiosSerialLen = FindAwardBios(&pBiosSerial);
			if (uBiosSerialLen == 0U)
			{
				uBiosSerialLen = FindAmiBios(&pBiosSerial);
				if (uBiosSerialLen == 0U)
				{
					uBiosSerialLen = FindPhoenixBios(&pBiosSerial);
				}
			}

			if (uBiosSerialLen != 0U)
			{
				DbgPrint("pBiosSerial is valid,Len:%d!\r\n", uBiosSerialLen);
				RtlCopyMemory(szSystemInfo + uSystemInfoLen, pBiosSerial, uBiosSerialLen);
				uSystemInfoLen += uBiosSerialLen;

				char* str = (char*)pBiosSerial; // ֽͨתΪַָ
				DbgPrint("%s\r\n", str);
				ret = TRUE;
			}

			ZwUnmapViewOfSection((HANDLE)NtCurrentProcess(), (void*)ba);
		}
		else
		{
			DbgPrint("ZWmapV err:0x%x!\r\n", status);
		}
	}
	else
	{
		DbgPrint("ZWopenS err:0x%x!\r\n", status);
	}

	return TRUE;
}