// SpyBtn.cpp : ʵļ
//

#include "pch.h"
//#include "WinSPY.h"
#include "SpyBtn.h"
#include "resource.h"

#ifndef GCL_HCURSOR
#define GCL_HCURSOR         (-12)
#endif

// CSpyBtn

IMPLEMENT_DYNAMIC(CSpyBtn, CButton)

CSpyBtn::CSpyBtn()
{
	m_hCursor = AfxGetApp()->LoadCursor(IDC_CURSOR1);

	m_hIconPushed = AfxGetApp()->LoadIcon(IDI_ICON2);
	m_hIconUnpush = AfxGetApp()->LoadIcon(IDI_ICON3);
	//m_hIconUnpush = (HICON)LoadImage(AfxGetInstanceHandle(), MAKEINTRESOURCE(IDI_ICON3), IMAGE_ICON, 128, 128, LR_DEFAULTCOLOR);

	m_bCapture = FALSE;
	m_hOldWnd = NULL;
}

CSpyBtn::~CSpyBtn()
{
}


BEGIN_MESSAGE_MAP(CSpyBtn, CButton)
	ON_WM_LBUTTONDOWN()
	ON_WM_LBUTTONUP()
	ON_WM_MOUSEMOVE()
END_MESSAGE_MAP()



// CSpyBtn Ϣ




void CSpyBtn::OnLButtonDown(UINT nFlags, CPoint point)
{
	// TODO: ڴϢ/Ĭֵ

	m_hOldCursor = (HCURSOR)SetClassLong(GetSafeHwnd(),
		GCL_HCURSOR,
		(LONG)m_hCursor); //޸İťĹ

	SetCapture();
	m_bCapture = TRUE;

	CButton::OnLButtonDown(nFlags, point);
}


void CSpyBtn::OnLButtonUp(UINT nFlags, CPoint point)
{
	// TODO: ڴϢ/Ĭֵ
	if (m_bCapture)
	{

		HWND hParente = GetParent()->GetSafeHwnd();
		::PostMessage(hParente, WM_SPYEND, (WPARAM)m_hOldWnd, NULL);


		CDC dc;
		dc.Attach(::GetDC(NULL)); //ȡĻDC
		dc.SetROP2(R2_XORPEN); //뱳ɫ

							   //һɫʺһˢ
		CPen pen;
		pen.CreatePen(PS_SOLID, 10, RGB(255, 255, 255));
		LOGBRUSH logBursh;
		logBursh.lbStyle = BS_NULL;
		CBrush brush;
		brush.CreateBrushIndirect(&logBursh);

		HGDIOBJ hOldPen = dc.SelectObject(pen);
		HGDIOBJ hOldBrush = dc.SelectObject(brush);

		//ȡԭĺڿ
		if (IsWindow(m_hOldWnd))
		{
			//ȡԭڵľδС
			CWnd* pOldWnd = FromHandle(m_hOldWnd);
			CRect rc;
			pOldWnd->GetWindowRect(&rc);

			dc.Rectangle(&rc);
		}

		dc.SelectObject(hOldPen);
		dc.SelectObject(hOldBrush);

		dc.Detach();
		m_hOldWnd = NULL;

		ReleaseCapture();

		(HCURSOR)SetClassLong(GetSafeHwnd(),
			GCL_HCURSOR,
			(LONG)m_hOldCursor); //޸İťĹ

		InvalidateRect(NULL);
		m_bCapture = FALSE;
		
	}

	CButton::OnLButtonUp(nFlags, point);
}


void CSpyBtn::OnMouseMove(UINT nFlags, CPoint point)
{
	// TODO: ڴϢ/Ĭֵ

	if (m_bCapture)
	{
		::SetCursor(m_hCursor);

		CDC dc;
		dc.Attach(::GetDC(NULL)); //ȡĻDC
		dc.SetROP2(R2_XORPEN); //뱳ɫ

							   //תĻ
		ClientToScreen(&point);
		CWnd* pWnd = WindowFromPoint(point); //ȡ

		if (pWnd->GetSafeHwnd() == m_hOldWnd)
		{
			return;
		}

		//ȡڵĴС
		CRect rcWindow;
		pWnd->GetWindowRect(&rcWindow);

		//һɫʺһˢ
		CPen pen;
		pen.CreatePen(PS_SOLID, 10, RGB(255, 255, 255));
		LOGBRUSH logBursh;
		logBursh.lbStyle = BS_NULL;
		CBrush brush;
		brush.CreateBrushIndirect(&logBursh);

		HGDIOBJ hOldPen = dc.SelectObject(pen);
		HGDIOBJ hOldBrush = dc.SelectObject(brush);

		//ƳԭĴ,ȡԭĺڿ
		if (m_hOldWnd != pWnd->GetSafeHwnd() && IsWindow(m_hOldWnd))
		{
			//ȡԭڵľδС
			CWnd* pOldWnd = FromHandle(m_hOldWnd);
			CRect rc;
			pOldWnd->GetWindowRect(&rc);

			dc.Rectangle(&rc);

			TRACE(_T("in %08X %d %d "), m_hOldWnd, rc.left, rc.top);
		}


		dc.Rectangle(&rcWindow);
		TRACE(_T("out %08X %d %d "), pWnd->GetSafeHwnd(), rcWindow.left, rcWindow.top);

		dc.SelectObject(hOldPen);
		dc.SelectObject(hOldBrush);

		dc.Detach();

		m_hOldWnd = pWnd->GetSafeHwnd();

		HWND hParente = GetParent()->GetSafeHwnd();
		::SendMessage(hParente, WM_SPY, (WPARAM)m_hOldWnd, NULL);

	}//endif (m_bCapture)

	CButton::OnMouseMove(nFlags, point);
}


void CSpyBtn::DrawItem(LPDRAWITEMSTRUCT lpDrawItemStruct)
{
	CDC dc;
	dc.Attach(lpDrawItemStruct->hDC);
	if (m_bCapture)
	{
		dc.DrawIcon(lpDrawItemStruct->rcItem.left,
			lpDrawItemStruct->rcItem.top,
			m_hIconPushed);
	}
	else
	{
		dc.DrawIcon(lpDrawItemStruct->rcItem.left,
			lpDrawItemStruct->rcItem.top - 5,
			m_hIconUnpush);
	}
	dc.Detach();
	// TODO:  ĴԻָ
}
