#include "pch.h"
#include "MapRelative.h"
#include "Chonghuishanhai.h"

const int MAP_ROWS = 5;
const int MAP_COLS = 5;

// Ƿ㱣㹻ľ
bool isValidPoint(int x, int y, const std::vector<std::pair<int, int>>& points, int minDistance) {
	for (const auto& point : points) {
		int dx = x - point.first;
		int dy = y - point.second;
		if ((dx * dx + dy * dy) < (minDistance * minDistance)) {
			return false;
		}
	}
	return true;
}

// ɵһ
std::pair<int, int> generateRandomPoint(int rows, int cols, 
	const std::vector<std::pair<int, int>>& points, 
	const std::vector<std::pair<int, int>>& samplePoints,
	bool useSample,int playerX, int playerY, int minDistance, IsCanArriveFun func) {
	while (true) {
		int x = 0, y = 0;

		if (useSample)
		{
			int nIndex = rand() % samplePoints.size();
			x = samplePoints[nIndex].first;
			y = samplePoints[nIndex].second;
		}
		else
		{
			x = rand() % rows;
			y = rand() % cols;
		}

		// ֤ǷΪ
		if (/*map[x][y] == 0*/ func(x, y, playerX, playerY)) {
			// ֤Һһľ
			DEBUG_OUTPUT("x:%d,y:%d.˵Ѱ·һ!\r\n", x, y);
			if (isValidPoint(x, y, points, minDistance) &&
				isValidPoint(x, y, { {playerX, playerY} }, minDistance)) {
				DEBUG_OUTPUT("x:%d,y:%d.˵Ѱ·!\r\n", x, y);
				return { x, y };
			}
		}
	}
}

// С룬ڵͼԽ߳
double calculateMinDistance(int width, int height,  int k = 10) {
	// ͼԽ߳
	double diagonal = sqrt(width * width + height * height);

	// ʹöԽ߳ȼС
	double minDistance = diagonal / k;

	// ȷС벻 5
	return max(5, minDistance);
}

// ɶһ
std::vector<std::pair<int, int>> generateMultiplePoints(int n, int rows, int cols,
	int playerX, int playerY,
	IsCanArriveFun func) {
	bool useSample = false;
	std::vector<std::pair<int, int>> points, samplePoints;

	int minDistance = calculateMinDistance(rows, cols);
	if (minDistance > 30) //̫󣬼Ѱ·̫
		minDistance = 30;

	DEBUG_OUTPUT("СΪ:%d!\r\n", minDistance);

	int num = (rows * cols) / (100 * 100); //ӳ䵽100*100ĵͼ
	int nSampleSize = sqrt(num); //ȡ
	if (nSampleSize <= 1)
	{
		useSample = false;
		DEBUG_OUTPUT("ӳΪ:11!\r\n");
	}
	else
	{
		useSample = true;
		DEBUG_OUTPUT("ӳΪ:%d1!\r\n", nSampleSize);
	}
	
	if (useSample)
	{
		for (int y = 0; y <= cols; y += nSampleSize)
		{
			for (int x = 0; x <= rows; x += nSampleSize)
			{
				int nXPoint = x + rand() % nSampleSize;
				int nYPoint = y + rand() % nSampleSize;
				samplePoints.push_back({ nXPoint, nYPoint });
			}
		}
	}
	
	for (int i = 0; i < n; ++i) {
		auto point = generateRandomPoint(rows, cols, points,
			samplePoints, useSample,playerX, playerY, minDistance, func);
		points.push_back(point);
	}

	return points;
}
