﻿// CMainDialog.cpp: 实现文件
//

#include "pch.h"
#include "SFG.h"
#include "afxdialogex.h"
#include "CMainDialog.h"
#include "Chonghuishanhai.h"
#include <atlconv.h>

HANDLE g_hWorkThread = NULL, g_hRecycleEquipThread = NULL;
BOOL g_bExitThread = FALSE, g_bPickUp = FALSE,
g_bRecycleEquip = FALSE, g_bRecycleEquipExit = FALSE;

HANDLE m_hRecycleEquipExit;

// CMainDialog 对话框

IMPLEMENT_DYNAMIC(CMainDialog, CDialogEx)

CMainDialog::CMainDialog(CWnd* pParent /*=nullptr*/)
	: CDialogEx(IDD_DIALOG_MAIN, pParent)
{
	init();
}

CMainDialog::~CMainDialog()
{
}

void CMainDialog::DoDataExchange(CDataExchange* pDX)
{
	CDialogEx::DoDataExchange(pDX);
}


BEGIN_MESSAGE_MAP(CMainDialog, CDialogEx)
	ON_BN_CLICKED(ID_START_WORK, &CMainDialog::OnBnClickedStartWork)
	ON_BN_CLICKED(IDC_CHECK_PICK, &CMainDialog::OnBnClickedCheckPick)
	ON_WM_HOTKEY()
	ON_BN_CLICKED(IDC_CHECK_RECYCLE, &CMainDialog::OnBnClickedCheckRecycle)
	ON_BN_CLICKED(IDCANCEL, &CMainDialog::OnBnClickedCancel)
END_MESSAGE_MAP()


// CMainDialog 消息处理程序

void CMainDialog::OnBnClickedStartWork()
{
	// TODO: 在此添加控件通知处理程序代码

	//CreateThread(0, 0, GenMap, 0, 0, 0);

	CString csStartWork = L"";
	GetDlgItemText(ID_START_WORK, csStartWork);
	if (csStartWork==L"开始挂机")
	{
		csStartWork = L"停止挂机";
		SetDlgItemText(ID_START_WORK, csStartWork);

		g_bExitThread = FALSE;

		g_hWorkThread = ::CreateThread(NULL, NULL,
			[](LPVOID)->DWORD
			{
				OutputDebugStringA("打开CMainDialog!\r\n");
				StartWork(NULL);
				return 0;
			}, NULL, NULL, NULL
		);
	}
	else
	{
		csStartWork = L"开始挂机";
		SetDlgItemText(ID_START_WORK, csStartWork);

		g_bExitThread = TRUE;

		DWORD dwWaitResult= WaitForSingleObject(g_hWorkThread, 2000);
		//等待超时，结束线程
		if (dwWaitResult == WAIT_TIMEOUT)
		{
			DEBUG_OUTPUT("等待超时，结束线程!\r\n");
			TerminateThread(g_hWorkThread, 0);
		}
		CloseHandle(g_hWorkThread);
		g_hWorkThread = NULL;
	}
}


void CMainDialog::OnBnClickedCheckPick()
{
	// TODO: 在此添加控件通知处理程序代码

	g_bPickUp = !g_bPickUp;
	_printf("g_bPickUp:%d", g_bPickUp);
}

void CMainDialog::OnBnClickedCheckRecycle()
{
	// TODO: 在此添加控件通知处理程序代码

	g_bRecycleEquip = !g_bRecycleEquip;
	_printf("g_bRecycleEquip:%d", g_bRecycleEquip);

	if (g_bRecycleEquip)
	{
		g_bRecycleEquipExit = FALSE;
		ResetEvent(m_hRecycleEquipExit);

		g_hRecycleEquipThread = ::CreateThread(NULL, NULL,
			[](LPVOID)->DWORD
			{
				OutputDebugStringA("开启RecycleEquipmentThread线程!\r\n");
				RecycleEquipmentThread(NULL);
				return 0;
			}, NULL, NULL, NULL
		);
	}
	else
	{
		g_bRecycleEquipExit = TRUE;
		SetEvent(m_hRecycleEquipExit);

		DWORD dwWaitResult = WaitForSingleObject(g_hRecycleEquipThread, 2000);
		//等待超时，结束线程
		if (dwWaitResult == WAIT_TIMEOUT)
		{
			DEBUG_OUTPUT("等待超时，结束线程!\r\n");
			TerminateThread(g_hRecycleEquipThread, 0);
		}
		CloseHandle(g_hRecycleEquipThread);
		g_hRecycleEquipThread = NULL;
	}
}

void CMainDialog::OnHotKey(UINT nHotKeyId, UINT nKey1, UINT nKey2)
{
	// TODO: 在此添加消息处理程序代码和/或调用默认值

	OutputDebugStringA("OnHotKey\r\n");
	UINT Mod = nKey1; // key-modifier flags 
	UINT uVirtKey = nKey2; // virtual-key code 
	//判断响应了什么热键 
	if (MOD_CONTROL == Mod && '1' == uVirtKey)
	{
		UseRandomStone();
	}
	else if (MOD_CONTROL == Mod && '2' == uVirtKey)
	{
		littleQuit();
	}
	else if (MOD_CONTROL == Mod && '3' == uVirtKey)
	{
		CString strText;
		GetDlgItemText(IDC_EDIT_SPEAK, strText);
		//声明标识符
		USES_CONVERSION;
		char* pSpeak = W2A(strText);
		Speak(pSpeak);
	}

	CDialogEx::OnHotKey(nHotKeyId, nKey1, nKey2);
}


BOOL CMainDialog::OnInitDialog()
{
	CDialogEx::OnInitDialog();

	// TODO:  在此添加额外的初始化

	m_hRecycleEquipExit = CreateEvent(NULL, TRUE, FALSE, NULL);

	//不要写在构造函数CMainDialog::CMainDialog里，
	//虽然RegisterHotKey会成功，但没响应热键
	//后面可以用CHotKeyCtrl控件
	OutputDebugStringA("Start RegisterHotKey\r\n");
	if (!RegisterHotKey(GetSafeHwnd(), 1, MOD_CONTROL, '1'))
	{
		char szOutput[256] = { 0 };
		sprintf_s(szOutput, sizeof(szOutput), "RegisterHotKey error 1:%d\r\n",
			GetLastError());
		OutputDebugStringA(szOutput);
	}
	if (!RegisterHotKey(GetSafeHwnd(), 2, MOD_CONTROL, '2'))
	{
		char szOutput[256] = { 0 };
		sprintf_s(szOutput, sizeof(szOutput), "RegisterHotKey error 2:%d\r\n",
			GetLastError());
		OutputDebugStringA(szOutput);
	}
	if (!RegisterHotKey(GetSafeHwnd(), 3, MOD_CONTROL, '3'))
	{
		char szOutput[256] = { 0 };
		sprintf_s(szOutput, sizeof(szOutput), "RegisterHotKey error 3:%d\r\n",
			GetLastError());
		OutputDebugStringA(szOutput);
	}

	return TRUE;  // return TRUE unless you set the focus to a control
	// 异常: OCX 属性页应返回 FALSE
}


void CMainDialog::OnBnClickedCancel()
{
	// TODO: 在此添加控件通知处理程序代码
	CDialogEx::OnCancel();
}
