// mem_x64.c : ʵx64/IA32e/ģʽҳ/ڴģ͡.
//       : ѧ򶹶
//
#include "MemX64.h"
#include "VmWareApp.h"
#include "vad.h"

#define PTE_SWIZZLE_MASK                               0x0         //Todo:ʱ֧
#define PTE_SWIZZLE_BIT                                0x10        // nt!_MMPTE_SOFTWARE.SwizzleBit
#define MEM_X64_PTE_IS_HARDWARE(pte)                  (pte & 0x01)
#define MEM_X64_MEMMAP_DISPLAYBUFFER_LINE_LENGTH      89

#define MEM_X64_PTE_PAGE_FILE_NUMBER(pte)          ((pte >> 12) & 0x0f)
#define MEM_X64_PTE_PAGE_FILE_OFFSET(pte)          ((pte >> 32) ^ (!(pte & PTE_SWIZZLE_BIT) ? PTE_SWIZZLE_MASK : 0))

#define MEM_X64_PTE_IS_FILE_BACKED(pte)            (((pte & 0xffff80000000000f) == 0xffff800000000000))

/*
nt!_MMPTE_PROTOTYPE
+ 0x000 Valid            : Pos 0, 1 Bit
+ 0x000 DemandFillProto : Pos 1, 1 Bit
+ 0x000 HiberVerifyConverted : Pos 2, 1 Bit
+ 0x000 ReadOnly : Pos 3, 1 Bit
+ 0x000 SwizzleBit : Pos 4, 1 Bit
+ 0x000 Protection : Pos 5, 5 Bits
+ 0x000 Prototype : Pos 10, 1 Bit
+ 0x000 Combined : Pos 11, 1 Bit
+ 0x000 Unused1 : Pos 12, 4 Bits
+ 0x000 ProtoAddress : Pos 16, 48 Bits
*/
#define MEM_X64_PTE_PROTOTYPE(pte)                    (((pte & 0x8000000000070401) == 0x8000000000000400) ? ((pte >> 16) | 0xffff000000000000) : 0)

/*
nt!_MMPTE_TRANSITION
+ 0x000 Valid            : Pos 0, 1 Bit
+ 0x000 Write : Pos 1, 1 Bit
+ 0x000 Spare : Pos 2, 1 Bit
+ 0x000 IoTracker : Pos 3, 1 Bit
+ 0x000 SwizzleBit : Pos 4, 1 Bit
+ 0x000 Protection : Pos 5, 5 Bits
+ 0x000 Prototype : Pos 10, 1 Bit
+ 0x000 Transition : Pos 11, 1 Bit
+ 0x000 PageFrameNumber : Pos 12, 36 Bits
+ 0x000 Unused : Pos 48, 16 Bits
*/
#define MEM_X64_PTE_TRANSITION(pte)                   (((pte & 0x0c01) == 0x0800) ? ((pte & 0xffffdffffffff000) | 0x005) : 0)
#define MEM_X64_PTE_IS_TRANSITION(H, pte, iPML)       ((((pte & 0x0c01) == 0x0800) && (iPML == 1) && (H->vmm.tpSystem == VMM_SYSTEM_WINDOWS_X64)) ? ((pte & 0xffffdffffffff000) | 0x005) : 0)
#define MEM_X64_PTE_IS_VALID(pte, iPML)               (pte & 0x01)


DWORD64 MemX64Prototype(_In_ DWORD64 pte,_In_ DWORD64 DirectoryTableBase)
{
	DWORD64 PtePage = 0;
	do
	{
		if (!pte || !DirectoryTableBase){
			break;
		}
		if (!VMReadVmVirtualAddr(&PtePage, DirectoryTableBase, MEM_X64_PTE_PROTOTYPE(pte), 8)) {
			break;
		}

		if (!PtePage) {
			break;
		}

		//ԭPTESubsection Pte,ʱûд
		//PTEHard/Transition/PageFile ȥ
		if (MEM_X64_PTE_PROTOTYPE(PtePage)) {
			PtePage = 0;
			break;
		}

	} while (FALSE);
	
	return PtePage;
}

//ڴȡҳҳ
VMM_PTE_TP MemX64TransitionPaged(_In_ DWORD64 va, _In_ DWORD64 pte, _In_ DWORD64 DirectoryTableBase, _In_ DWORD64 Flags, _Out_ PDWORD64 ppa)
{
	DWORD PfNumber = 0;
	DWORD PfOffset = 0;
	DWORD PteTp = VMM_PTE_TP_NA;
	do
	{
		//ʼ
		*ppa = 0;
		/*
		ЧPTE(ӲPTE)
		PTEЧλMMUͷãִеַת,ͲǷҳڴ
		*/
		if (MEM_X64_PTE_IS_HARDWARE(pte))
		{
			PteTp = VMM_PTE_TP_HARDWARE;
			*ppa = pte & 0x0000fffffffff000;
			break;
		}
		/*Чpte(PTE)--------------------------------------------------------------------------------------------------------------------------------------------
		4ЧPTE1ЧPTE(ԭPTE)

		ڵַתPTEЧλΪ㣬PTEʾЧҳʱڴ쳣ҳ
		MMUPTEʣλ˲ϵͳʹЩλ洢ҳϢ⽫ڽҳ
		гЧpteṹЩͨΪpteΪڴMMU͵*/
		/*ЧPTE֣
		1ڷҳļ
		2Ҫ0ҳ
		3ҳת
	    4δ֪ҪVAD
		*/	

		/* ԭ״̬
           1ͬҳ಻ͬĽ֮乲Ϊֻö PTE ͬһҳ档ϵͳЭҳ޼
		ͬһҳãϵͳҪ罫ҳ¶λҳļУҪ͸Щá
		Чʷǳͣ Windows ʹһ֡ӡPTE ҳ涨һ PTE - Ϊԭ PTE
		ˣֻҪԭ PTEùڴ PTE Զ¡

		  2ӲPTE ͬԭ PTE ڲڴݽṹCPU Ӳʹִ⵽ַתǽ Windows ҳڽҳϵҳ

		ԭPTE:ԭPTE4KBҳ棬
		ԭPTE,ҳɴ6״̬֮һ
		lЧactivevalidΪ̿Է, Ըҳλڴ
		2תtransltionĿҳλڴеĴб޸бλ беΡڡ
		3޸Ĳдmodihed no writeĿҳλڴ,λ޸Ĳдбڣ
		4Ҫ㣨demandzeroĿҳӦһҳ㡣
		5ҳļpageFileĿҳפҳļ
		6ӳļmappedFileĿҳפӳļ
		*/
		if (MEM_X64_PTE_PROTOTYPE(pte)) {
			PteTp = VMM_PTE_TP_PROTOTYPE;
			pte = MemX64Prototype(pte, DirectoryTableBase);
			if (MEM_X64_PTE_IS_HARDWARE(pte)) {
				*ppa = pte & 0x0000fffffffff000;
				break;
			}
		}

	     /*״̬
		   Windowsһ - һӽ̵ĹɾҳPOSIXиΪ֪פǽ̿Էʵҳļϣ
		ԽҳɾҳļУϵͳпҳǣҳдҳļȽҳת״̬
		Ժҳдҳļͬʱڴ԰ЧݣԷԺҪҳ棨ԿٴطصУ
		ˣתеҳЧݣǵ̷ʱӲὫpageerrorҳϵͳУô򽫼򵥵ؽҳΪЧ
		ת־ڴ״̬ԭ͡־ڹر״̬ҳ洦ڡת״̬
		*/
		if (MEM_X64_PTE_TRANSITION(pte)) {
			PteTp = VMM_PTE_TP_TRANSITION;
			pte = MEM_X64_PTE_TRANSITION(pte);
			if ((pte & 0x0000fffffffff000)) {
				*ppa = pte & 0x0000fffffffff000;
			}
			break;
		}

		//Todo:ĿǰûʵֶдRead/Write pagefile.sysд
		PfNumber = MEM_X64_PTE_PAGE_FILE_NUMBER(pte);
		PfOffset = MEM_X64_PTE_PAGE_FILE_OFFSET(pte);

		/*VADԭPTEVADӲPTE

		 VADԭPTE
		Ӳ PTE ԭ PTE Valid = 0Prototype = 1 ProtoAddress ֵ0xFFFFFFFF0000 VAD ԭ͡
		£Ǳҵ۵ַӦVADȻMMVAD ṹһϵ VAD ΧӦ PTE
		ȻǼԭʼַVADƫҵӦPTE

		磬ǳԽַ0x10000
		ҳȷVADԭPTEProtoAddress = 0xFFFFFFFF0000
		ڹVADȤ򡣼ҵһ0x80000x20000
		_MMVADһ FirstPrototypePte Աָ 0xFFFF1000000
		ˣҪ PTE λ 0x10000 - 0x8000 / 0x1000 + 0xFFFF1000000
		ǴӸ PTE ַ

		 VadӲPTE
		 PTE ȫΪ 0ʾӦѯ VADָ PTE  PDE ЧҳЧʱƺҲˡ£ҪVADԭPTEͬķʽVAD
		״̬ƺ״̬ͬ*/

		if (va && !MEM_IS_KERNEL_ADDR_X64(va) && (!pte || (PfOffset == 0xffffffff) && !(Flags & VM_FLAG_NOVAD))) {			
			pte = VADFindVadPte(va);
			if (!pte) {
				break;
			}
			if (MEM_X64_PTE_IS_HARDWARE(pte)) {
				PteTp = VMM_PTE_TP_HARDWARE;
				*ppa = pte & 0x0000fffffffff000;
				break;
			}
			PteTp= MemX64TransitionPaged(va, pte, DirectoryTableBase, Flags | VM_FLAG_NOVAD, ppa);
			break;
		}

		if (!pte) {
			break;
		}

		// Ҫ㣨demandzeroĿҳӦһҳ[ nt!_MMPTE_SOFTWARE ]
		//ЧPTEĵ2ԭPTEĵ4
		if (!PfNumber && !PfOffset) {
			PteTp = VMM_PTE_TP_DEMANDZERO;
			break;
		}

		//WIN11ļֵ֧ڴ(Ŀǰ֧)
		if (MEM_X64_PTE_IS_FILE_BACKED(pte)) {
			PteTp = VMM_PTE_TP_FILE_BACKED;
			break;
		}

		//win10ѹڴڴ(PageFile.sys)
	} while (FALSE);

	return PteTp;
}
